#include <bits/stdc++.h>
using namespace std;

typedef long long ll;

struct Ponco {
  ll w;
  ll v;
  double ratio;

  bool operator<(const Ponco &rhs) const { return ratio < rhs.ratio; }
};

ll dilemma(int idx, ll w, ll v, vector<Ponco> const &poncoi, ll wmax) {
  if (w > wmax) {
    return -1;
  }
  if (idx == poncoi.size()) {
    // cout << w << endl;
    return v;
  }
  return max(
      dilemma(idx + 1, w + poncoi[idx].w, v + poncoi[idx].v, poncoi, wmax),
      dilemma(idx + 1, w, v, poncoi, wmax));
}

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(0);
  cout.tie(0);
  cerr.tie(0);

  int n, w;
  double epsilon;
  cin >> n >> w >> epsilon;

  vector<Ponco> poncoi;
  ll wi, vi;
  for (int i = 0; i < n; i++) {
    cin >> wi >> vi;
    poncoi.push_back(Ponco{wi, vi, (double)wi / (double)vi});
  }

  sort(poncoi.begin(), poncoi.end());

  cout << dilemma(0, 0, 0, poncoi, w) << endl;

  return 0;
}